IF NOT EXISTS	(SELECT * FROM SYS.OBJECTS  WHERE NAME = 'EST_PROD_INF_DIVERS')

BEGIN
	        CREATE TABLE EST_PROD_INF_DIVERS
	        (
			 CD_EMP        INT NOT NULL, 
	         CD_PROD       INT NOT NULL, 
	         OBRIG_RECEITA INT NOT NULL, 
	         USO_CONTIN   INT NOT NULL, 
	         END_FOTO     VARCHAR(150) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL, 
	         CONSTRAINT PK_TABLE1 PRIMARY KEY CLUSTERED(CD_EMP ASC, CD_PROD ASC, OBRIG_RECEITA ASC)
	         WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	        )
	        ON [PRIMARY];

	ALTER TABLE EST_PROD_INF_DIVERS
	ADD CONSTRAINT DF_TABLE1_CD_EMP DEFAULT((0)) FOR CD_EMP;
	
	ALTER TABLE EST_PROD_INF_DIVERS
	ADD CONSTRAINT DF_TABLE1_CD_PROD DEFAULT((0)) FOR CD_PROD;
	
	ALTER TABLE EST_PROD_INF_DIVERS
	ADD CONSTRAINT DF_TABLE1_OBRIG_RECEITA DEFAULT((0)) FOR OBRIG_RECEITA;
	
	ALTER TABLE EST_PROD_INF_DIVERS
	ADD CONSTRAINT DF_TABLE1_USO_CONTIN DEFAULT((0)) FOR USO_CONTIN;
	
	ALTER TABLE EST_PROD_INF_DIVERS
	ADD CONSTRAINT DF_TABLE1_END_FOTO DEFAULT('') FOR END_FOTO;
	
	ALTER TABLE EST_PROD_INF_DIVERS
	WITH NOCHECK
	ADD CONSTRAINT FK_EST_PROD_INF_DIVERS_EST_PROD FOREIGN KEY(CD_EMP, CD_PROD) REFERENCES EST_PROD(CD_EMP, 
	                                                                                                              CD_PROD) ON UPDATE CASCADE;
	
	ALTER TABLE EST_PROD_INF_DIVERS CHECK CONSTRAINT FK_EST_PROD_INF_DIVERS_EST_PROD;

END;